# V2 SR Present‑Act Engine — SR Demo

This repository contains a faithful, reproducible implementation of the **V2 present‑act engine**
special relativity (SR) demo plus a full suite of parameter variations.  It was generated
programmatically within the OpenAI agent environment and serves as a canonical reference
for the passing SR run.

## How to run

First create a virtual environment and install dependencies:

```bash
python -m venv .venv
source .venv/bin/activate      # Windows: .venv\Scripts\activate
pip install -r requirements.txt
```

Then run the baseline acceptance demo to generate the plots, tables, manifest, and
acceptance report:

```bash
python src/sr_v2_demo_baseline.py
```

To run the parameter variations suite:

```bash
python src/sr_v2_variations_suite.py
```

Outputs will be written into the `results/` directory by default, with the manifest
files stored in `manifests/` and the human‑readable acceptance report stored in
`REPORTS/`.  If you wish to direct outputs to a different location, you can
specify an `sr_out_dir` argument when calling `run_baseline()`.

## Contents

* `src/` — Source code for the baseline demo and the variations suite.
* `results/` — Generated plots (PNG), tables (CSV/JSON) and variation summaries.
* `manifests/` — Manifest JSON/YAML capturing the run parameters and acceptance
  thresholds.
* `REPORTS/` — Human‑readable acceptance summary.
* `requirements.txt` — Python dependencies (`numpy`, `pandas`, `matplotlib`, `PyYAML`).

## Governance overview

This SR demo adheres to the non‑negotiable governance defined in the V2
specification.  In summary:

* **Roles on arrows only:** L1/L2/L3 are roles on edges, not layers.
* **No curves/pivots as weights:** Diagnostics (UGM, logistic D(n), etc.) are
  permitted only as reports, never as dynamic multipliers.
* **No‑skip composition:** Long updates must factor through neighbours.
* **Gates are feasibility:** Θ (act window) and κ (minimal outward part) serve
  only as pass/fail constraints.
* **Fit rule Φ(W,Q)=0:** Commit decisions rely solely on feasibility
  (budget + arrow + no‑skip) with lexicographic tie-breaking; probabilities are
  assigned only after feasibility using PF/Born.
* **Ledger is diagnostic:** Residuals are printed and never fed back into
  control.
* **c=1 invariant:** The conversion between 0‑time and +1‑time is fixed at 1
  (or another rational value if calibrated in a different sector).

The baseline acceptance run verifies these conditions by computing ledger
residuals, measuring dilation vs theory, checking cone boundaries, and testing
re‑centering and no‑skip invariants.  Passing results are recorded in
`REPORTS/sr_v2_report.txt`.